(height, percent, charge, low, lbr, m_color, b_color) {
	var line_Width = 1;
	var r = height / 5;
	var s = height / 20;
	var m = 5;
	
	var canvas_stroke = document.createElement("canvas");
	canvas_stroke.height = r * 2;
	canvas_stroke.width = canvas_stroke.height;
	var ctx_stroke  = canvas_stroke.getContext("2d");
	ctx_stroke.lineWidth = line_Width;
	ctx_stroke.strokeStyle="rgb(" + b_color.slice(0, 3).join()+ ")";
	ctx_stroke.arc( r, r, r-line_Width/2 , 0, 2*Math.PI );
	ctx_stroke.stroke();
	var img_stroke = ctx_stroke.getImageData(0, 0, canvas_stroke.width, canvas_stroke.height);

	var canvas_fill = document.createElement("canvas");
	canvas_fill.height = r * 2;
	canvas_fill.width = canvas_fill.height;
	var ctx_fill  = canvas_fill.getContext("2d");
	ctx_fill.fillStyle="rgb(" + m_color.join()+ ")";
	ctx_fill.arc( r, r, r-(line_Width+s), 0, 2*Math.PI );
	ctx_fill.fill();
	var img_fill = ctx_fill.getImageData(line_Width+s, line_Width+s, canvas_fill.width-2*(line_Width+s), canvas_fill.height-2*(line_Width+s));
	
	var canvas = document.createElement("canvas");
	canvas.height = height / 2;
	canvas.width = 2*r * 5 + m*4;
	var ctx  = canvas.getContext("2d");
	var p_Center = height / 4 ;
	
	for ( i = 0 ; i < 5 ; i++ ){
		ctx.putImageData(img_stroke, i*(2*r+m), p_Center-r);
		if ( i+1 <= percent/20 ) {
			ctx.putImageData(img_fill, i*(2*r+m)+line_Width+s, p_Center-r+line_Width+s);
		}
		else if ( i < percent/20 ) {
			var rectWidth = 2*(r-(line_Width+s)) * (percent%20) / 20;
			ctx.putImageData(img_fill, i*(2*r+m)+line_Width+s, p_Center-r+line_Width+s, 0, 0, rectWidth, 2*(r-(line_Width+s)));
		}
	}
	
	return canvas.toDataURL("image/png");
}