var id_bg, ctx_bg; 

var id_hour, ctx_hour; 

var id_minute, ctx_minute; 

var id_second, ctx_second; 



function init() {

    id_bg = document.getElementById("bg");

    ctx_bg = id_bg.getContext("2d");

    id_hour = document.getElementById("hour");

    ctx_hour = id_hour.getContext("2d");

    id_minute = document.getElementById("minute");

    ctx_minute = id_minute.getContext("2d");

    id_second = document.getElementById("second");

    ctx_second = id_second.getContext("2d");

    //　短針

    ctx_hour.beginPath();

    ctx_hour.lineWidth = 30;

    ctx_hour.strokeStyle = "silver";

    ctx_hour.moveTo(320, 320);

    ctx_hour.lineTo(320, 160);

    ctx_hour.stroke();

    ctx_hour.beginPath();

    //　長針

    ctx_minute.beginPath();

    ctx_minute.lineWidth = 20;

    ctx_minute.strokeStyle = "silver";

    ctx_minute.moveTo(320, 320);

    ctx_minute.lineTo(320, 0);

    ctx_minute.stroke();

    //　秒針

    ctx_second.beginPath();

    ctx_second.lineWidth = 3;

    ctx_second.strokeStyle = "red";

    ctx_second.moveTo(320, 320);

    ctx_second.lineTo(320, 0);

    ctx_second.stroke();

    // 文字盤

    ctx_bg.beginPath();

    var grad  = ctx_bg.createRadialGradient(320,320,0,320,320,320);

    grad.addColorStop(0,"white");

	grad.addColorStop(1,"black");

    ctx_bg.fillStyle = grad;

    ctx_bg.arc(320, 320, 320, 0, 2 * Math.PI, false);

    ctx_bg.fill();

    

    //　目盛り＆数字

    for(i=1; i<=60; i++){

	ctx_bg.beginPath();

	ctx_bg.strokeStyle = "white";

	if(i%5 == 0){

	    ctx_bg.lineWidth = 10;

	    ctx_bg.moveTo(320+ 270*Math.cos(i*Math.PI/30), 320+ 270*Math.sin(i*Math.PI/30));

	    ctx_bg.fillStyle = "white";

	    ctx_bg.font = "bold 48px sans-serif";

	    ctx_bg.textAlign = "center";

	    ctx_bg.fillText(i/5, 320+ 240*Math.sin(i*Math.PI/30), 338- 240*Math.cos(i*Math.PI/30));

	}else{

	    ctx_bg.lineWidth = 3;

	    ctx_bg.moveTo(320+ 290*Math.cos(i*Math.PI/30), 320+ 290*Math.sin(i*Math.PI/30));

	}

	ctx_bg.lineTo(320+ 320*Math.cos(i*Math.PI/30), 320+ 320*Math.sin(i*Math.PI/30));

	ctx_bg.stroke();

    }



    setTime();

}



function setTime() {

    get_date = new Date();

    cr_hours = get_date.getHours();

    cr_minutes = get_date.getMinutes();

    cr_seconds = get_date.getSeconds();



    s_angle = cr_seconds*6;

    id_second.style.webkitTransform = "rotate(" + s_angle + "deg)";

    m_angle = cr_minutes*6;

    id_minute.style.webkitTransform = "rotate(" + m_angle + "deg)";

    h_angle = cr_hours*30;

    id_hour.style.webkitTransform = "rotate(" + h_angle + "deg)";

    

    setTimeout("setTime()",1000);



}