function setWeather () {
  var url="http://rss.rssad.jp/rss/tenki/forecast/city_60.xml";
  var httpRequest = new XMLHttpRequest();

  httpRequest.open("GET", url);
  httpRequest.overrideMimeType("text/xml");
  httpRequest.setRequestHeader('Cache-Control', 'no-cache'); 
  httpRequest.send(null); 
  httpRequest.onload = function() {xml_responded(httpRequest);}
}

function findChild (element, nodeName){
  var child;
	
  for (child = element.firstChild; child != null; child = child.nextSibling){
    if (child.nodeName == nodeName) return child;
  }
	
  return null;
}

function xml_responded (request) {
  var rss = findChild(request.responseXML, "rss");
  var channel = findChild(rss, "channel");
  var city = findChild(channel, "title").textContent;
  city = city.substring(0, city.indexOf("の"));
  document.getElementById("city").innerText = city;
   
  var forecast, date, day, max, min, image, title, url;
  var tag_item = request.responseXML.getElementsByTagName("item");
  for (var i = 0; i < tag_item.length; i++) {
      forecast = findChild(tag_item[i], "title").textContent;
      date = forecast.substring(0, forecast.indexOf("("));
      day = forecast.substring(forecast.indexOf("("),forecast.indexOf(")")+1);
      max = forecast.substring(forecast.lastIndexOf(" ")+1,forecast.lastIndexOf("/"));
      min = forecast.substring(forecast.lastIndexOf("/")+1);
      image = findChild(tag_item[i], "image");
      title = findChild(image, "title").textContent;
      url = findChild(image, "url").textContent;
      
      document.getElementById("date" + i).innerText = date;
      document.getElementById("day" + i).innerText = day;
      document.getElementById("image" + i).src = url;
      document.getElementById("text" + i).innerText = title;
      document.getElementById("temp" + i).innerText = max + " / " + min;
  }
}
