function setWeather () {
  var url="http://weather.jp.msn.com/RSS.aspx?wealocations=wc:9758041&weadegreetype=C&culture=ja-JP";
  var httpRequest = new XMLHttpRequest();

  httpRequest.open("GET", url);
  httpRequest.overrideMimeType("text/xml");
  httpRequest.setRequestHeader('Cache-Control', 'no-cache'); 
  httpRequest.send(null); 
  httpRequest.onload = function() {xml_responded(httpRequest);}
}

function findChild (element, nodeName){
  var child;
	
  for (child = element.firstChild; child != null; child = child.nextSibling){
    if (child.nodeName == nodeName) return child;
  }
	
  return null;
}

function xml_responded (request) {
  var rss = findChild(request.responseXML, "rss");
  var channel = findChild(rss, "channel");
  var city = findChild(channel, "title").textContent;
  city = city.substring(0, city.indexOf("-"));
  document.getElementById("city").innerText = city;

  var item = findChild(channel, "item");
  var description = findChild(item, "description").textContent;
  var desc = description.split("<br />");

  var day, max, min, probability, title, url;
  for (var i = 0; i < desc.length-2; i++) {
      day = desc[i].substring(desc[i].indexOf("rss")+5,desc[i].indexOf("</a>"));
      title = desc[i].substring(desc[i].indexOf("alt")+5,desc[i].indexOf("title")-2);
      min = desc[i].substring(desc[i].indexOf("最低"),desc[i].indexOf(". 最高"));
      max = desc[i].substring(desc[i].indexOf("最高"),desc[i].indexOf(". 降水"));
      probability = desc[i].substring(desc[i].indexOf("降水"));
      url = desc[i].substring(desc[i].indexOf('src="')+5,desc[i].indexOf("width")-2);
      
      document.getElementById("day" + i ).innerText = day;
      document.getElementById("image" + i).src = url;
      document.getElementById("text" + i).innerText = title;
      document.getElementById("max" + i).innerHTML = max;
      document.getElementById("min" + i).innerHTML = min;
      document.getElementById("prob" + i).innerText = probability;
  }
}
