function setWeather () {
  var url="http://weather.jp.msn.com/RSS.aspx?wealocations=wc:9758041&weadegreetype=C&culture=ja-JP";
  var httpRequest = new XMLHttpRequest();

  httpRequest.open("GET", url);
  httpRequest.overrideMimeType("text/xml");
  httpRequest.setRequestHeader('Cache-Control', 'no-cache'); 
  httpRequest.send(null); 
  httpRequest.onload = function() {xml_responded(httpRequest);}
}

function findChild (element, nodeName){
  var child;
	
  for (child = element.firstChild; child != null; child = child.nextSibling){
    if (child.nodeName == nodeName) return child;
  }
	
  return null;
}

function xml_responded (request) {
  var rss = findChild(request.responseXML, "rss");
  var channel = findChild(rss, "channel");
  var city = findChild(channel, "title").textContent;
  city = city.substring(0, city.indexOf("-"));
  document.getElementById("city").innerText = city;

  var item = findChild(channel, "item");
  var description = findChild(item, "description").textContent;
  var desc = description.split("<br />");

  var forecast, date, day, max, min, image, title, url;
  var flag_min, flag_max, flag_prob;
  for (var i = 0; i < desc.length-2; i++) {
      flag_min = desc[i].indexOf("最低");
      flag_max = desc[i].indexOf("最高");
      flag_prob = desc[i].indexOf("降水");

      day = desc[i].substring(desc[i].indexOf("rss")+5,desc[i].indexOf("</a>"));
      title = desc[i].substring(desc[i].indexOf("alt")+5,desc[i].indexOf("title")-2);
      if( 0<flag_min && 0<flag_max){
        min = desc[i].substring(desc[i].indexOf("最低")+4,desc[i].indexOf("最高")-9);
      } else{
        min = "";
      }
      if( 0<flag_max && 0<flag_prob){
        max = desc[i].substring(desc[i].indexOf("最高")+4,desc[i].indexOf("降水")-9);
      } else{
        max = "";
      }
      if( 0<flag_prob ){
        probability = desc[i].substring(desc[i].indexOf("降水")+6);
      } else{
        probability = "";
      }
      url = desc[i].substring(desc[i].indexOf('src="')+5,desc[i].indexOf("width")-2);
      
      document.getElementById("day" + i ).innerText = day;
      document.getElementById("image" + i).src = url;
      document.getElementById("text" + i).innerText = title;
      document.getElementById("temp" + i).innerText = max + " / " + min ;
      document.getElementById("prob" + i).innerText = probability;
  }
}
